<?php
/**
 * Plugin Name: Free Short-Term Rental Booking (iCal)
 * Description: A professional short-term rental booking engine for WordPress. Includes advanced seasonal pricing (Summer, Winter, Holidays), dynamic discounts, and multi-currency support. Sync effortlessly with Airbnb, Booking.com, and more via two-way iCal integration. Features a responsive frontend calendar, customizable contact fields, additional services (cleaning, parking, etc.), and automated email notifications. Lightweight, collision-protected, and fully translatable.
 * Version: 1.0.7
 * Author: vachr.cz
 * License: GPLv2 or later
 * Text Domain: free-short-term-rental-booking
 */

if (!defined('ABSPATH')) exit;

define('FSTRB_VERSION', '1.0.7');
define('FSTRB_PLUGIN_FILE', __FILE__);
define('FSTRB_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('FSTRB_PLUGIN_URL', plugin_dir_url(__FILE__));

require_once FSTRB_PLUGIN_DIR . 'includes/db.php';
require_once FSTRB_PLUGIN_DIR . 'includes/cpt.php';
require_once FSTRB_PLUGIN_DIR . 'includes/shortcodes.php';
require_once FSTRB_PLUGIN_DIR . 'includes/rest.php';
require_once FSTRB_PLUGIN_DIR . 'includes/admin.php';
require_once FSTRB_PLUGIN_DIR . 'includes/ical.php';
require_once FSTRB_PLUGIN_DIR . 'includes/emails.php';

register_activation_hook(__FILE__, ['FSTRB_DB', 'activate']);
register_deactivation_hook(__FILE__, ['FSTRB_DB', 'deactivate']);

add_action('init', function() {
	FSTRB_CPT::register();
});

add_action('rest_api_init', ['FSTRB_REST', 'register']);

add_action('plugins_loaded', function() {
	if (get_option('fstrb_db_version') !== FSTRB_VERSION) {
		FSTRB_DB::activate();
		update_option('fstrb_db_version', FSTRB_VERSION);
	}
	$path = dirname(plugin_basename(__FILE__)) . '/languages';
	$loaded = load_plugin_textdomain('free-short-term-rental-booking', false, $path);
	if (isset($_GET['debug_i18n'])) {
		error_log("FSTRB i18n: Locale=" . get_locale() . " Path=$path Loaded=" . ($loaded ? 'YES' : 'NO'));
	}
});

add_action('wp_enqueue_scripts', function() {
	wp_register_style('fstrb-theme-integration', FSTRB_PLUGIN_URL . 'assets/theme-integration.css', [], FSTRB_VERSION);
	wp_register_style('fstrb-frontend', FSTRB_PLUGIN_URL . 'assets/frontend.css', ['fstrb-theme-integration'], FSTRB_VERSION);
	wp_register_script('fstrb-frontend', FSTRB_PLUGIN_URL . 'assets/frontend.js', ['wp-api-fetch'], FSTRB_VERSION, true);

	wp_localize_script('fstrb-frontend', 'FSTRB', FSTRB_Shortcodes::get_localization_data());
});

add_action('admin_enqueue_scripts', function($hook) {
	// Only our admin pages
	if (strpos($hook, 'fstrb') === false) return;
	wp_enqueue_style('fstrb-admin', FSTRB_PLUGIN_URL . 'assets/admin.css', [], FSTRB_VERSION);
	wp_enqueue_script('fstrb-admin', FSTRB_PLUGIN_URL . 'assets/admin.js', ['jquery'], FSTRB_VERSION, true);
});
