<?php
if (!defined('ABSPATH')) exit;

class FSTRB_Emails {

	public static function notify_admin_new_booking($booking_id) {
		global $wpdb;
		$t = FSTRB_DB::tables();
		$booking = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$t['bookings']} WHERE id = %d", $booking_id));

		if (!$booking) return;

		$admin_email = get_option('admin_email');
		$unit_title = get_the_title($booking->unit_id);
		
		$subject = sprintf(__('New Booking: %s', 'free-short-term-rental-booking'), $unit_title);
		
		$message = sprintf(__("New booking received for %s", 'free-short-term-rental-booking'), $unit_title) . "\n\n";
		$message .= __("ID:", 'free-short-term-rental-booking') . " " . $booking->id . "\n";
		$message .= __("Customer:", 'free-short-term-rental-booking') . " " . $booking->customer_name . " " . $booking->customer_lastname . "\n";
		$message .= __("Email:", 'free-short-term-rental-booking') . " " . $booking->customer_email . "\n";
		$message .= __("Phone:", 'free-short-term-rental-booking') . " " . $booking->customer_phone . "\n";
		$message .= __("Dates:", 'free-short-term-rental-booking') . " " . $booking->date_from . " to " . $booking->date_to . "\n";
		$message .= __("Total:", 'free-short-term-rental-booking') . " " . $booking->total_price . " " . $booking->currency . "\n";
		$message .= __("Note:", 'free-short-term-rental-booking') . " " . $booking->note . "\n\n";
		$message .= __("Manage bookings:", 'free-short-term-rental-booking') . " " . admin_url('admin.php?page=fstrb');

		wp_mail($admin_email, $subject, $message);
	}

	public static function notify_customer_confirmed($booking_id) {
		global $wpdb;
		$t = FSTRB_DB::tables();
		$booking = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$t['bookings']} WHERE id = %d", $booking_id));

		if (!$booking || empty($booking->customer_email)) return;

		$unit_title = get_the_title($booking->unit_id);
		$subject = sprintf(__('Booking Confirmed: %s', 'free-short-term-rental-booking'), $unit_title);

		$message = sprintf(__("Hello %s,", 'free-short-term-rental-booking'), $booking->customer_name) . "\n\n";
		$message .= __("Your booking has been confirmed.", 'free-short-term-rental-booking') . "\n\n";
		$message .= __("Details:", 'free-short-term-rental-booking') . "\n";
		$message .= __("Unit:", 'free-short-term-rental-booking') . " " . $unit_title . "\n";
		$message .= __("Dates:", 'free-short-term-rental-booking') . " " . $booking->date_from . " to " . $booking->date_to . "\n";
		$message .= __("Total Price:", 'free-short-term-rental-booking') . " " . $booking->total_price . " " . $booking->currency . "\n\n";
		$message .= __("Thank you!", 'free-short-term-rental-booking');

		wp_mail($booking->customer_email, $subject, $message);
	}
}
