<?php
if (!defined('ABSPATH')) exit;

class FSTRB_Shortcodes {
	public static function register() {
		add_shortcode('fstrb_booking_form', [__CLASS__, 'booking_form']);
		add_shortcode('fstrb_availability_calendar', [__CLASS__, 'availability_calendar']);
	}

	public static function enqueue_frontend() {
		if (!wp_style_is('fstrb-frontend', 'registered')) {
			// Fallback registration if global hook failed or context is weird
			wp_register_style('fstrb-theme-integration', plugins_url('/assets/theme-integration.css', dirname(__FILE__)), [], '0.1.1');
			wp_register_style('fstrb-frontend', plugins_url('/assets/frontend.css', dirname(__FILE__)), ['fstrb-theme-integration'], '0.1.1');
			wp_register_script('fstrb-frontend', plugins_url('/assets/frontend.js', dirname(__FILE__)), ['wp-api-fetch'], '0.1.1', true);
		}

		wp_enqueue_style('fstrb-theme-integration');
		wp_enqueue_style('fstrb-frontend');
		wp_enqueue_script('fstrb-frontend');

		$mode = get_option('fstrb_styling_mode', 'off');
		$visual = get_option('fstrb_visual_settings', []);
		$css = '';

		$is_en = function($key) use ($visual) {
			return (!isset($visual[$key . '_en']) || $visual[$key . '_en']);
		};

		// --- Global Styling (Metadata & Layout) ---
		// These settings apply regardless of the main styling mode
		
		// Metadata Styling
		if ($is_en('meta_style')) {
			$meta_style = !empty($visual['meta_style']) ? $visual['meta_style'] : 'list';
			
			// Container Layout
			$css .= ".fstrb-services .fstrb-meta-container { margin-left: 28px !important; margin-top: 4px !important; line-height: 1.4 !important; font-size: 0.85em !important; } ";

			if ($meta_style === 'inline_bold' || $meta_style === 'inline_normal') {
				$css .= ".fstrb-services .fstrb-meta-row { display: inline-block !important; margin-right: 0 !important; } ";
				
				// Bold Key?
				if ($meta_style === 'inline_bold') {
					$css .= ".fstrb-services .fstrb-meta-key { font-weight: bold !important; } ";
				}

				// Separator
				if ($is_en('meta_sep')) {
					$sep = !empty($visual['meta_sep']) ? $visual['meta_sep'] : '';
					if ($sep) {
						$sep_content = '"' . esc_js($sep) . '"'; 
						$css .= ".fstrb-services .fstrb-meta-row:not(:last-child)::after { content: {$sep_content}; margin: 0 6px; color: #999; } ";
					} else {
						$css .= ".fstrb-services .fstrb-meta-row:not(:last-child) { margin-right: 10px !important; } ";
					}
				} else {
					$css .= ".fstrb-services .fstrb-meta-row:not(:last-child) { margin-right: 10px !important; } ";
				}

			} else {
				// List (default)
				$css .= ".fstrb-services .fstrb-meta-row { display: block !important; margin-bottom: 2px !important; } ";
			}
		}

		// --- Main Styling Mode Logic ---
		if ($mode === 'css') {
			$url = get_option('fstrb_custom_css_url', '');
			if ($url) {
				wp_enqueue_style('fstrb-custom', $url, ['fstrb-frontend']);
			}
		}
		
		// --- Visual Settings (Independent Toggles) ---
			// 1. Font Family
			if ($is_en('font_family') && !empty($visual['font_family'])) {
				$css .= '.fstrb { font-family: ' . sanitize_text_field($visual['font_family']) . ' !important; } ';
			}

			// 2. Max Width
			if ($is_en('max_width') && !empty($visual['max_width'])) {
				$unit = !empty($visual['max_width_unit']) ? $visual['max_width_unit'] : 'px';
				if (!in_array($unit, ['px', '%'])) $unit = 'px';
				$css .= '.fstrb { max-width: ' . (int)$visual['max_width'] . $unit . ' !important; } ';
			}

			// 3. Font Size
			if ($is_en('font_size') && !empty($visual['font_size'])) {
				$css .= '.fstrb { font-size: ' . (int)$visual['font_size'] . 'px !important; } ';
			}

			// 4. Form Background
			if ($is_en('form_bg') && !empty($visual['form_bg'])) {
				$fbg = sanitize_hex_color($visual['form_bg']);
				$css .= ".fstrb-booking { background-color: {$fbg} !important; border-radius: 8px; padding: 15px; } "; 
			}

			// 5. Calendar Colors
			if ($is_en('cal_bg') && !empty($visual['cal_bg'])) {
				$bg = sanitize_hex_color($visual['cal_bg']);
				$css .= ".fstrb-calendar, .fstrb-cal-grid { background-color: {$bg} !important; } ";
			}
			if ($is_en('cal_text') && !empty($visual['cal_text'])) {
				$text = sanitize_hex_color($visual['cal_text']);
				$css .= ".fstrb-calendar { color: {$text} !important; } ";
			}
			if ($is_en('cal_active') && !empty($visual['cal_active'])) {
				$active = sanitize_hex_color($visual['cal_active']);
				$css .= ".fstrb-pill-sel { background-color: {$active} !important; } ";
				$css .= ".fstrb-selected-range { background-color: transparent !important; font-size: 1.2em !important; font-weight: bold; color: inherit; padding: 0; } ";
				
				$sel_text = ($is_en('cal_sel_text') && !empty($visual['cal_sel_text'])) ? sanitize_hex_color($visual['cal_sel_text']) : '#ffffff';
				$css .= ".fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.sel { background-color: {$active} !important; } ";
				$css .= ".fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.sel, .fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.sel .d { color: {$sel_text} !important; } ";
				$css .= ".fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.inrange { background-color: {$active} !important; opacity: 0.7; } ";
				$css .= ".fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.inrange, .fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.inrange .d { color: {$sel_text} !important; } ";
			}
			if ($is_en('cal_occupied') && !empty($visual['cal_occupied'])) {
				$occ = sanitize_hex_color($visual['cal_occupied']);
				$css .= ".fstrb-pill-occ { background-color: {$occ} !important; } ";
				
				$occ_text = ($is_en('cal_occ_text') && !empty($visual['cal_occ_text'])) ? sanitize_hex_color($visual['cal_occ_text']) : '#ffffff';
				$css .= ".fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.occ:not(.fstrb-checkin):not(.fstrb-checkout):not(.fstrb-checkout-checkin) { background-color: {$occ} !important; opacity: 1 !important; } ";
				$css .= ".fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.occ:not(.fstrb-checkin):not(.fstrb-checkout):not(.fstrb-checkout-checkin), 
						 .fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.occ:not(.fstrb-checkin):not(.fstrb-checkout):not(.fstrb-checkout-checkin) .d { color: {$occ_text} !important; } ";
				$css .= ".fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.occ .tag { color: {$occ_text} !important; opacity: 0.9; } "; 
				
				// --- Transitions ---
				$trans = '#ffffff'; 

				// Check-out
				$css .= ".fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.fstrb-checkout { background: linear-gradient(135deg, {$occ} 50%, {$trans} 50%) !important; } ";
				$css .= ".fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.fstrb-checkout, .fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.fstrb-checkout .d { color: inherit !important; } ";
				if (!empty($active)) {
					$css .= ".fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.fstrb-checkout.sel, .fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.fstrb-checkout.inrange { background: linear-gradient(135deg, {$occ} 50%, {$active} 50%) !important; } ";
					$css .= ".fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.fstrb-checkout.sel, .fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.fstrb-checkout.sel .d,
							 .fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.fstrb-checkout.inrange, .fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.fstrb-checkout.inrange .d { color: {$sel_text} !important; } ";
				}

				// Check-in
				$css .= ".fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.fstrb-checkin { background: linear-gradient(135deg, {$trans} 50%, {$occ} 50%) !important; } ";
				$css .= ".fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.fstrb-checkin, .fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.fstrb-checkin .d { color: inherit !important; } ";
				if (!empty($active)) {
					$css .= ".fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.fstrb-checkin.sel, .fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.fstrb-checkin.inrange { background: linear-gradient(135deg, {$active} 50%, {$occ} 50%) !important; } ";
					$css .= ".fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.fstrb-checkin.sel, .fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.fstrb-checkin.sel .d,
							 .fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.fstrb-checkin.inrange, .fstrb-calendar .fstrb-cal-grid .fstrb-cal-day.fstrb-checkin.inrange .d { color: {$sel_text} !important; } ";
				}
			}
				 // Text colors for transitions: The "tag" (Available/Occupied/[Transition]) might need color tweak?
				 // Usually text is black on white part, white on red part. Hard to do without mix-blend-mode or complex HTML.
				 // For now, let's leave text inherit, but ensure .occ parts have contrast if possible.
				 // Actually, if selected, text should be white (as it's blue/red).


			// 5.5 & 5.6 Calendar Text Outline & Shadow
			$shadows = [];
			
			// 1. Outline
			if ($is_en('cal_outline') && !empty($visual['cal_outline'])) {
				$out_color = sanitize_hex_color($visual['cal_outline']);
				$out_size = (int)($visual['cal_outline_size'] ?? 1);
				$shadows[] = "-{$out_size}px -{$out_size}px 0 {$out_color}";
				$shadows[] = "{$out_size}px -{$out_size}px 0 {$out_color}";
				$shadows[] = "-{$out_size}px {$out_size}px 0 {$out_color}";
				$shadows[] = "{$out_size}px {$out_size}px 0 {$out_color}";
			}

			// 2. Custom Shadow
			if ($is_en('bs_color') && !empty($visual['bs_color'])) {
				$bsc = sanitize_hex_color($visual['bs_color']);
				$bsx = (int)($visual['bs_x'] ?? 0);
				$bsy = (int)($visual['bs_y'] ?? 4);
				$bsb = (int)($visual['bs_blur'] ?? 10);
				// text-shadow technically doesn't support spread in standard CSS, but we'll include blur
				$shadows[] = "{$bsx}px {$bsy}px {$bsb}px {$bsc}";
			}

			if (!empty($shadows)) {
				$css .= ".fstrb-cal-day { text-shadow: " . implode(', ', $shadows) . " !important; } ";
			}

			// 5.7 Calendar Dates Styling
			$d_css = '';
			if ($is_en('cal_date_size')) $d_css .= 'font-size: ' . (int)$visual['cal_date_size'] . 'px !important; ';
			if ($is_en('cal_date_color')) $d_css .= 'color: ' . sanitize_hex_color($visual['cal_date_color']) . ' !important; ';
			if ($is_en('cal_date_weight')) $d_css .= 'font-weight: bold !important; ';
			if ($d_css) {
				$css .= ".fstrb-cal-day .d { {$d_css} } ";
				// Also apply color to the day container to ensure consistency if no .d is present
				if ($is_en('cal_date_color')) $css .= ".fstrb-cal-day { color: " . sanitize_hex_color($visual['cal_date_color']) . " !important; } ";
			}

			// 5.8 Calendar Labels Styling (Tags inside days and Legend pills)
			$l_css = '';
			if ($is_en('cal_lbl_size')) $l_css .= 'font-size: ' . (int)$visual['cal_lbl_size'] . 'px !important; ';
			if ($is_en('cal_lbl_color')) $l_css .= 'color: ' . sanitize_hex_color($visual['cal_lbl_color']) . ' !important; ';
			if ($is_en('cal_lbl_weight')) $l_css .= 'font-weight: bold !important; ';
			if ($l_css) {
				$css .= ".fstrb-cal-day .tag, .fstrb-cal-legend .fstrb-pill { {$l_css} } ";
			}


		// 6. Section Headings Styling
		// Calendar Heading
		if ($is_en('cal_h_text')) {
			$h_css = '';
			if ($is_en('cal_h_size')) $h_css .= 'font-size: ' . (int)$visual['cal_h_size'] . 'px !important; ';
			if ($is_en('cal_h_color')) $h_css .= 'color: ' . sanitize_hex_color($visual['cal_h_color']) . ' !important; ';
			if ($is_en('cal_h_weight')) $h_css .= 'font-weight: bold !important; ';
			if ($is_en('cal_h_align')) $h_css .= 'text-align: ' . sanitize_text_field($visual['cal_h_align']) . ' !important; ';
			if ($h_css) $css .= ".fstrb-cal-h { {$h_css} margin-bottom: 15px; } ";
		}
		// Booking Form Heading
		if ($is_en('frm_h_text')) {
			$h_css = '';
			if ($is_en('frm_h_size')) $h_css .= 'font-size: ' . (int)$visual['frm_h_size'] . 'px !important; ';
			if ($is_en('frm_h_color')) $h_css .= 'color: ' . sanitize_hex_color($visual['frm_h_color']) . ' !important; ';
			if ($is_en('frm_h_weight')) $h_css .= 'font-weight: bold !important; ';
			if ($h_css) $css .= ".fstrb-frm-h { {$h_css} margin-bottom: 15px; } ";
		}


		// 7. Booking Button Styling
		if ($is_en('btn_bg') || $is_en('btn_color') || $is_en('btn_size') || $is_en('btn_radius') || $is_en('btn_font') || $is_en('btn_weight')) {
			$btn_css = '';
			if ($is_en('btn_bg') && !empty($visual['btn_bg'])) {
				$bg = sanitize_hex_color($visual['btn_bg']);
				$btn_css .= "background-color: {$bg} !important; border-color: {$bg} !important; ";
			}
			if ($is_en('btn_color') && !empty($visual['btn_color'])) {
				$col = sanitize_hex_color($visual['btn_color']);
				$btn_css .= "color: {$col} !important; ";
			}
			if ($is_en('btn_size') && !empty($visual['btn_size'])) {
				$btn_css .= "font-size: " . (int)$visual['btn_size'] . "px !important; ";
			}
			if ($is_en('btn_radius') && isset($visual['btn_radius'])) { // radius can be 0
				$btn_css .= "border-radius: " . (int)$visual['btn_radius'] . "px !important; ";
			}
			if ($is_en('btn_font') && !empty($visual['btn_font'])) {
				$btn_css .= "font-family: " . sanitize_text_field($visual['btn_font']) . " !important; ";
			}
			if ($is_en('btn_weight') && !empty($visual['btn_weight'])) {
				$btn_css .= "font-weight: bold !important; ";
			}
			
			if ($btn_css) {
				$css .= ".fstrb-btn-primary { {$btn_css} } ";
			}
		}

		// Apply collected inline CSS (from Global + Visual mode if active)
		if ($css) {
			wp_add_inline_style('fstrb-frontend', $css);
		}
	}

	private static function render_calendar($unit_id, $is_booking = false, $months = 1, $grid = null) {
		$grid = $grid !== null ? (int)$grid : (int)$months;
		$vis = get_option('fstrb_visual_settings', []);
		ob_start();

		if (!$is_booking && !empty($vis['cal_h_text_en']) && !empty($vis['cal_h_text'])) {
			echo '<span class="fstrb-cal-h">' . esc_html($vis['cal_h_text']) . '</span>';
		}
?>
		<div class="fstrb fstrb-calendar <?php echo $is_booking ? 'fstrb-calendar-in-form' : ''; ?>" 
			 data-unit="<?php echo esc_attr($unit_id); ?>" 
			 data-months="<?php echo (int)$months; ?>"
			 data-grid="<?php echo (int)$grid; ?>"
			 data-currency="<?php echo esc_attr($atts['currency'] ?? ''); ?>">
		  <div class="fstrb-cal-head">
			<button class="fstrb-btn fstrb-prev" type="button">‹</button>
			<div class="fstrb-cal-title"></div>
			<button class="fstrb-btn fstrb-next" type="button">›</button>
		  </div>
		  <div class="fstrb-cal-grid-container">
			<div class="fstrb-cal-grid"></div>
		  </div>
		  <div class="fstrb-cal-legend">
			<span class="fstrb-pill fstrb-pill-free"><?php _e('Available', 'free-short-term-rental-booking'); ?></span>
			<span class="fstrb-pill fstrb-pill-occ"><?php _e('Occupied', 'free-short-term-rental-booking'); ?></span>
			<span class="fstrb-pill fstrb-pill-sel"><?php _e('Selection', 'free-short-term-rental-booking'); ?></span>
		  </div>
		  <div class="fstrb-cal-selected">
			<span class="fstrb-selected-range"></span>
		  </div>
		</div>
		<?php
		return ob_get_clean();
	}

	public static function booking_form($atts) {
		$atts = shortcode_atts(['unit'=>'0', 'months'=>'1', 'grid'=>NULL, 'currency'=>'EUR'], $atts, 'fstrb_booking_form');
		$unit_id = (int)$atts['unit'];
		if (!$unit_id) return '<div class="fstrb-error">' . __('Unit missing.', 'free-short-term-rental-booking') . '</div>';

		if (get_post_meta($unit_id, '_fstrb_is_paused', true)) {
			return '<div class="fstrb-error">' . __('This apartment is temporarily unavailable for booking.', 'free-short-term-rental-booking') . '</div>';
		}

		self::enqueue_frontend();

		$currency = $atts['currency'];
		
		ob_start();
		$vis = get_option('fstrb_visual_settings', []);
		if (!empty($vis['frm_h_text_en']) && !empty($vis['frm_h_text'])) {
			echo '<h3 class="fstrb-frm-h">' . esc_html($vis['frm_h_text']) . '</h3>';
		}
		?>
		<div class="fstrb fstrb-booking" data-unit="<?php echo esc_attr($unit_id); ?>" data-currency="<?php echo esc_attr($currency); ?>">
		  <div class="fstrb-selection-row">
			<?php if (!empty($vis['cal_h_text_en'])): ?>
			<label class="fstrb-label-block"><?php echo esc_html(!empty($vis['cal_h_text']) ? $vis['cal_h_text'] : __('Availability Calendar', 'free-short-term-rental-booking')); ?></label>
			<?php endif; ?>
			<?php echo self::render_calendar($unit_id, true, $atts['months'], $atts['grid']); ?>
			<input type="hidden" class="fstrb-date-from" />
			<input type="hidden" class="fstrb-date-to" />
		  </div>
		  
		  <div class="fstrb-row">
			<label><?php _e('Guests', 'free-short-term-rental-booking'); ?></label>
			<input type="number" class="fstrb-guests" min="1" value="1" />
		  </div>

		  <?php 
		  $vis = get_option('fstrb_visual_settings', []);
		  $svc_en = !isset($vis['svc_label_en']) || $vis['svc_label_en'];
		  if ($svc_en && !empty($vis['svc_label'])) {
			  echo '<div class="fstrb-row"><label class="fstrb-label-block">' . esc_html($vis['svc_label']) . '</label></div>';
		  }
		  ?>
		  <div class="fstrb-services fstrb-services-box"></div>

		  <div class="fstrb-row fstrb-quote">
			<span class="fstrb-total-label"><?php _e('Total price with selected services', 'free-short-term-rental-booking'); ?>:</span>
			<span class="fstrb-total"></span>
			<span class="fstrb-currency"><?php echo esc_html($currency); ?></span>
		  </div>

		  <div class="fstrb-row fstrb-row-half">
			<div class="fstrb-field">
			  <label><?php _e('First Name', 'free-short-term-rental-booking'); ?> *</label>
			  <input type="text" class="fstrb-name" required />
			</div>
			<div class="fstrb-field">
			  <label><?php _e('Last Name', 'free-short-term-rental-booking'); ?> *</label>
			  <input type="text" class="fstrb-lastname" required />
			</div>
		  </div>
		  <div class="fstrb-row">
			<label><?php _e('Gender', 'free-short-term-rental-booking'); ?></label>
			<select class="fstrb-gender">
				<option value="male"><?php _e('Male', 'free-short-term-rental-booking'); ?></option>
				<option value="female"><?php _e('Female', 'free-short-term-rental-booking'); ?></option>
				<option value="other"><?php _e('Other', 'free-short-term-rental-booking'); ?></option>
			</select>
		  </div>
		  <div class="fstrb-row">
			<label><?php _e('Email', 'free-short-term-rental-booking'); ?> *</label>
			<input type="email" class="fstrb-email" required />
		  </div>
		  <div class="fstrb-row">
			<label><?php _e('Phone', 'free-short-term-rental-booking'); ?> *</label>
			<div class="fstrb-phone-wrapper" style="display: flex; gap: 5px;">
			  <select class="fstrb-phone-prefix" style="flex: 0 0 100px;">
				<option value="+420">+420 (CZ)</option>
				<option value="+421">+421 (SK)</option>
				<option value="+49">+49 (DE)</option>
				<option value="+43">+43 (AT)</option>
				<option value="+48">+48 (PL)</option>
				<option value="+44">+44 (UK)</option>
				<option value="+1">+1 (US/CA)</option>
				<option value="+33">+33 (FR)</option>
				<option value="+39">+39 (IT)</option>
				<option value="+34">+34 (ES)</option>
				<option value="+31">+31 (NL)</option>
				<option value="+32">+32 (BE)</option>
				<option value="+41">+41 (CH)</option>
			  </select>
			  <input type="text" class="fstrb-phone" required style="flex: 1;" />
			</div>
		  </div>

		  <div class="fstrb-custom-fields fstrb-row-v"></div>

		  <div class="fstrb-row">
			<label><?php _e('Note', 'free-short-term-rental-booking'); ?></label>
			<textarea class="fstrb-note"></textarea>
		  </div>

		  <div class="fstrb-row fstrb-hp" style="display:none !important">
			<label>Leave this empty</label>
			<input type="text" class="fstrb-honeypot" tabindex="-1" autocomplete="off" />
		  </div>

		  <div class="fstrb-row fstrb-captcha-row">
			<label><?php _e('Are you a human? What is 2 + 3?', 'free-short-term-rental-booking'); ?> *</label>
			<input type="text" class="fstrb-captcha" placeholder="?" required />
		  </div>

		  <div class="fstrb-row">
			<?php 
			$btn_label = __('Send Booking', 'free-short-term-rental-booking');
			if (!empty($vis['btn_text_en']) && !empty($vis['btn_text'])) {
				$btn_label = esc_html($vis['btn_text']);
			}
			?>
			<button class="fstrb-btn fstrb-btn-primary fstrb-submit"><?php echo $btn_label; ?></button>
			<span class="fstrb-msg"></span>
		  </div>
		  <div style="text-align: right; font-size: 10px; color: #999999a6; margin-top: 20px; opacity: 0.7;">
			<?php _e('WP plugin Free Short Term Rental Booking', 'free-short-term-rental-booking'); ?>
		  </div>
		</div>
		<div class="fstrb-thanks" style="display:none; text-align:center; padding: 40px 20px;">
		   <h3 style="color: #2c3e50;"><?php _e('Thank You!', 'free-short-term-rental-booking'); ?></h3>
		   <p style="font-size: 1.1em; color: #7f8c8d;"><?php _e('We have received your booking request. We are looking forward to your visit and will contact you shortly.', 'free-short-term-rental-booking'); ?></p>
		   <div style="font-size: 3em; margin-top: 20px;">🏠✨</div>
		</div>
		<?php
		return ob_get_clean();
	}

	public static function availability_calendar($atts) {
		$atts = shortcode_atts(['unit'=>'0', 'months'=>'1', 'grid'=>NULL, 'currency'=>'EUR'], $atts, 'fstrb_availability_calendar');
		$unit_id = (int)$atts['unit'];
		if (!$unit_id) return '<div class="fstrb-error">' . __('Unit missing.', 'free-short-term-rental-booking') . '</div>';

		if (get_post_meta($unit_id, '_fstrb_is_paused', true)) {
			return '<div class="fstrb-error">' . __('Temporarily unavailable.', 'free-short-term-rental-booking') . '</div>';
		}

		self::enqueue_frontend();

		return self::render_calendar($unit_id, false, $atts['months'], $atts['grid']);
	}

	public static function get_localization_data() {
		return [
			'restUrl' => esc_url_raw(rest_url('fstrb/v1')),
			'nonce'   => wp_create_nonce('wp_rest'),
			'locale'  => substr(get_locale(), 0, 2),
			'i18n' => [
				'selectDates' => __('Select dates', 'free-short-term-rental-booking'),
				'loading' => __('Loading…', 'free-short-term-rental-booking'),
				'occupied' => __('Occupied', 'free-short-term-rental-booking'),
				// Inject Pricing Types (includes 'free' => 'free (service)')
				...FSTRB_CPT::get_service_pricing_types(),
				// Override 'free' for calendar use (must be AFTER spread to override)
				'free' => __('Available', 'free-short-term-rental-booking'),
				'freeSvc' => __('free (service)', 'free-short-term-rental-booking'),
				'nights' => __('nights', 'free-short-term-rental-booking'),
				'total' => __('Total', 'free-short-term-rental-booking'),
				'success' => __('Booking sent successfully!', 'free-short-term-rental-booking'),
				'error' => __('Error sending booking.', 'free-short-term-rental-booking'),
				'noServices' => __('No optional services.', 'free-short-term-rental-booking'),
				'errorLoadingServices' => __('Error loading services.', 'free-short-term-rental-booking'),
				'missingContact' => __('Fill in all required fields (indicated by *).', 'free-short-term-rental-booking'),
				'checkout' => __('Check-out', 'free-short-term-rental-booking'),
				'transition' => __('Transition', 'free-short-term-rental-booking'),
				'minStay' => __('Minimum stay is %d nights.', 'free-short-term-rental-booking'),
				'maxStay' => __('Maximum stay is %d nights.', 'free-short-term-rental-booking'),
				'captchaError' => __('Please answer the security question correctly.', 'free-short-term-rental-booking'),
				'robotError' => __('Robots are not allowed!', 'free-short-term-rental-booking'),
				'mon' => __('Mo', 'free-short-term-rental-booking'),
				'tue' => __('Tu', 'free-short-term-rental-booking'),
				'wed' => __('We', 'free-short-term-rental-booking'),
				'thu' => __('Th', 'free-short-term-rental-booking'),
				'fri' => __('Fr', 'free-short-term-rental-booking'),
				'sat' => __('Sa', 'free-short-term-rental-booking'),
				'sun' => __('Su', 'free-short-term-rental-booking'),
				'discount' => __('Discount', 'free-short-term-rental-booking'),
			],
		];
	}
}

add_action('init', ['FSTRB_Shortcodes', 'register']);
